<?php


class Corrensa_IntegrityCheck_View extends Settings_Vtiger_Index_View {
    function __construct()
    {
        parent::__construct();
    }
    function process(Vtiger_Request $request)
    {
        global $root_directory;
        echo "<div style='padding:10px; margin-bottom: 50px'>";
        echo "<h2>Integrity Check for Corrensa</h2>";


        echo "<h3>Database</h3>";
        $vtigerData = new Corrensa_VtigerData_Model();
        $modules = $vtigerData->getEntityModules();
        $defaultModuleFields = array(
            'Events' =>array('activitytype','description','eventstatus','subject','date_start','due_date','time_end','time_start','assigned_user_id','contact_id','parent_id'),
            'Leads' =>array('company','firstname','lastname','designation','email','secondaryemail','phone','mobile','fax','leadstatus','leadsource','industry','assigned_user_id','description','city','code','country','lane','state'),
            'Calendar' =>array('activitytype','description','taskstatus','subject','date_start','due_date','time_start','assigned_user_id','contact_id','parent_id'),
            'Contacts' =>array('account_id','firstname','lastname','title','email','secondaryemail','phone','mobile','homephone','otherphone','fax','leadsource','assigned_user_id','description','mailingcity','mailingcountry','mailingpobox','mailingstate','mailingstreet','mailingzip'),
            'Accounts' =>array('accountname','accounttype','assigned_user_id','email1','fax','otherphone','phone','rating','bill_city','bill_code','bill_code','bill_state','bill_street'),
            'HelpDesk' =>array('assigned_user_id','contact_id','parent_id','ticketcategories','ticketpriorities','ticketstatus','ticket_no','ticket_title','description','solution'),
            'Potentials' =>array('amount','assigned_user_id','closingdate','contact_id','description','leadsource','nextstep','opportunity_type','potentialname','related_to','sales_stage'),
        );
        $skipFields=array('image', 'purchase_cost','margin', 'update_log', 'comments');
        foreach ($modules as $moduleName => $moduleInfo) {
            echo "<strong>Checking module : $moduleName - START</strong><br>";
            $moduleModel=Vtiger_Module_Model::getInstance($moduleName);
            $fields=$moduleModel->getFields();
            foreach ($fields as $fieldName => $fieldModel){
                if(in_array($fieldName, $skipFields)) continue;
                if(!$fieldModel->isActiveField()){
                    echo "&nbsp;&nbsp; <span style='color: red'>Field '$fieldName' is not actived</span> <br>";
                }else{
                    if(!$this->CheckColumnExists($fieldModel->get('table'),$fieldModel->get('column'))){
                        echo "&nbsp;&nbsp; <span style='color: red'>Column '$fieldName' is not existed in the {$fieldModel->get('table')} table</span> <br>";
                    }
                }
            }
            if($defaultModuleFields[$moduleName]) {
                foreach ($defaultModuleFields[$moduleName] as $fieldName){
                    $fieldModel=$moduleModel->getField($fieldName);
                    if(!$fieldModel || !$fieldModel->isActiveField()){
                        echo "&nbsp;&nbsp; <span style='color: red'>Default Field '$fieldName' is not actived</span> <br>";
                    }
                }
            }
            echo "<strong>Checking module : $moduleName - END</strong><br><br>";

        }

        echo "<h3>Files</h3>";
        echo "<h4>Corrensa Files</h4>";
        $arrCorrensaFiles = array('modules/Corrensa/actions/Ajax.php','modules/Corrensa/actions/EmailAjax.php','modules/Corrensa/actions/Event.php','modules/Corrensa/actions/SettingAjax.php','modules/Corrensa/actions/Uninstall.php','modules/Corrensa/api/API_Documents.php','modules/Corrensa/api/API_Emails.php','modules/Corrensa/api/API_RelatedRecord.php','modules/Corrensa/api/API_Search.php','modules/Corrensa/api/API_Update.php','modules/Corrensa/api/API_User.php','modules/Corrensa/api/API_Version.php','modules/Corrensa/api/BaseModule.php','modules/Corrensa/handlers/ActionHandler.php','modules/Corrensa/handlers/SyncData.php','modules/Corrensa/libs/CorrensaCrypter.php','modules/Corrensa/libs/CorrensaHttp.php','modules/Corrensa/libs/utils.php','modules/Corrensa/models/DocumentModuleModel.php','modules/Corrensa/models/DocumentRelationListView.php','modules/Corrensa/models/Event.php','modules/Corrensa/models/Module.php','modules/Corrensa/models/ModuleSettings.php','modules/Corrensa/models/PotentialEmailListView.php','modules/Corrensa/models/RelationListView.php','modules/Corrensa/models/VtigerData.php','modules/Corrensa/views/IntegrityCheck.php','modules/Corrensa/views/PotentialEmail.php','modules/Corrensa/views/List.php','modules/Corrensa/views/Settings.php','modules/Corrensa/views/ShowInfo.php','modules/Corrensa/views/Uninstall.php','modules/Corrensa/api.php','modules/Corrensa/auto-update.php','modules/Corrensa/Config.php','modules/Corrensa/Corrensa.php','modules/Corrensa/ws.php');

        echo "<strong>Checking Corrensa Files - START</strong><br>";
        foreach ($arrCorrensaFiles as $file){
            if(!file_exists($root_directory.$file)) {
                echo "&nbsp;&nbsp; <span style='color: red'>File '$file' does not exist</span> <br>";
            }
        }
        echo "<strong>Checking Corrensa Files - END</strong><br>";


        echo "<h4>Standard Files</h4>";
        $arrStandardFiles = array('webservice.php','include/Webservices/AuthToken.php','include/Webservices/Create.php','include/Webservices/DataTransform.php','include/Webservices/Delete.php','include/Webservices/DescribeObject.php','include/Webservices/EntityMeta.php','include/Webservices/Login.php','include/Webservices/Logout.php','include/Webservices/ModuleTypes.php','include/Webservices/OperationManager.php','include/Webservices/Query.php','include/Webservices/QueryParser.php','include/Webservices/QueryRelated.php','include/Webservices/RelatedTypes.php','include/Webservices/Relation.php','include/Webservices/Retrieve.php','include/Webservices/Update.php','include/Webservices/Utils.php','include/Webservices/VtigerActorOperation.php','include/Webservices/VtigerCRMActorMeta.php','include/Webservices/VtigerCRMObject.php','include/Webservices/VtigerCRMObjectMeta.php','include/Webservices/VtigerModuleOperation.php','include/Webservices/VtigerWebserviceObject.php','include/Webservices/VTQL_Lexer.php','include/Webservices/VTQL_Parser.php','include/Webservices/WebserviceEntityOperation.php','include/Webservices/WebserviceField.php','include/Webservices/WebServiceErrorCode.php','include/Webservices/WebServiceError.php','include/Webservices/SessionManager.php','include/Webservices/RelatedModuleMeta.php','include/Webservices/GetUpdates.php');
        echo "<strong>Checking Standard Files - START</strong><br>";
        foreach ($arrStandardFiles as $file){
            if(!file_exists($root_directory.$file)) {
                echo "&nbsp;&nbsp; <span style='color: red'>File '$file' does not exist</span> <br>";
            }
        }
        echo "<strong>Checking Standard Files - END</strong><br>";

        echo "<h3>Environment</h3>";
        echo "<strong>Checking Environment - START</strong><br>";
        if(!extension_loaded('curl')) {
            echo "&nbsp;&nbsp; <span style='color: red'>The php library php_curl is not installed/enabled.</span> <br>";
        }
        if(!extension_loaded('mcrypt')) {
            echo "&nbsp;&nbsp; <span style='color: red'>The php library php_mcrypt is not installed/enabled.</span> <br>";
        }

        $connected = fopen("https://dashboard.vtexperts.com/", "r");
        if (!$connected) {
            echo "&nbsp;&nbsp; <span style='color: red'>Cannot connect to Corrensa Server.</span> <br>";
        }
        echo "<strong>Checking Environment - END</strong><br>";


        echo "<button style='margin-top: 20px' class='btn btn-primary' id='btnApiTest'>API TEST</button>";
        echo "<button style='margin-top: 20px; margin-left: 50px' class='btn btn-primary' id='btnCompareConfig'>COMPARE CONFIG</button>";
        echo "</div>";
    }

    public function CheckColumnExists($tableName, $column)
    {
        global $adb;
        $res = $adb->pquery('SELECT 1 FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND COLUMN_NAME=?',
            [$adb->dbName, $tableName, $column]);
        return $adb->num_rows($res) > 0;
    }

    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            'modules.Corrensa.resources.IntegrityCheck',
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}