<?php
class Corrensa_APITest_View extends Vtiger_IndexAjax_View {

    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer ($request);

        global $current_user, $site_URL;
        $currentUserModel = Users_Record_Model::getInstanceById($current_user->id, 'Users');
        $userName=$currentUserModel->get('user_name');
        $userPassword=$currentUserModel->get('user_password');
        $accessKey=$currentUserModel->get('accesskey');

        $arrResultMessage=array();
        // getchallenge
        $query = http_build_query(array(
            'operation' => 'getchallenge',
            'username' => $userName)
        );
        $wsUrl = $site_URL . 'webservice.php?';
        $url = $wsUrl.$query;
        $stream = curl_init();
        curl_setopt($stream, CURLOPT_HEADER, 0);
        curl_setopt($stream, CURLOPT_URL, $url);
        curl_setopt($stream, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($stream, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($stream, CURLOPT_USERAGENT, "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.1a2pre) Gecko/2008073000 Shredder/3.0a2pre ThunderBrowse/3.2.1.8");
        curl_setopt($stream, CURLOPT_SSL_VERIFYHOST, false);
        $challengeRs = curl_exec($stream);
        $challengeRs = json_decode($challengeRs);

        if ($challengeRs->success) {
            $arrResultMessage['GET CHALLENGE'] = true;
            // login
            $token = $challengeRs->result->token;
            $vtAccessKey = md5($token . $accessKey);

            $stream = curl_init();
            curl_setopt($stream, CURLOPT_URL, $wsUrl);
            curl_setopt($stream, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($stream, CURLOPT_POST, 1);
            curl_setopt($stream, CURLOPT_POSTFIELDS, array(
                'operation' => 'login',
                'username'  => $userName,
                'accessKey' => $vtAccessKey
            ));
            curl_setopt($stream, CURLOPT_USERAGENT, "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.1a2pre) Gecko/2008073000 Shredder/3.0a2pre ThunderBrowse/3.2.1.8");
            curl_setopt($stream, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($stream, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($stream, CURLOPT_HTTPHEADER, array(
                "Content-Type:multipart/form-data",
                "Connection:keep-alive",
                "Accept-Language:en-US,en;q=0.8",
            ));
            $loginRs = curl_exec($stream);
            $loginRs = json_decode($loginRs);
            if($loginRs->success) {
                $arrResultMessage['LOGIN'] = true;
                $sessionName = $loginRs->result->sessionName;
                $arrModules=array('Leads','Contacts', 'Accounts','HelpDesk','Potentials');
                foreach ($arrModules as $moduleName) {
                    $arrResultMessage['QUERY '.vtranslate($moduleName,$moduleName)] = $this->wsQueryTest($moduleName,$sessionName);
                }

            }else{
                $arrResultMessage['LOGIN'] = false;
            }
        }else{
            $arrResultMessage['GET CHALLENGE'] = false;
        }

        $viewer->assign('API_TEST_RESULT', $arrResultMessage);
        $viewer->view('APITest.tpl', 'Corrensa');
    }

    public function wsQueryTest($moduleName, $sessionName){
        global $site_URL;
        $query = "SELECT * FROM {$moduleName} LIMIT 0,5;";
        $query = http_build_query(array(
                'operation' => 'query',
                'sessionName' => $sessionName,
                'query' => $query
            )
        );

        $wsUrl = $site_URL . 'webservice.php?';
        $url = $wsUrl.$query;
        $stream = curl_init();
        curl_setopt($stream, CURLOPT_HEADER, 0);
        curl_setopt($stream, CURLOPT_URL, $url);
        curl_setopt($stream, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($stream, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($stream, CURLOPT_USERAGENT, "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.1a2pre) Gecko/2008073000 Shredder/3.0a2pre ThunderBrowse/3.2.1.8");
        curl_setopt($stream, CURLOPT_SSL_VERIFYHOST, false);
        $queryRs = curl_exec($stream);
        $queryRs = json_decode($queryRs);

        if ($queryRs->success) {
            return true;
        }else{
            return false;
        }
    }
}