jQuery.Class("Corrensa_IntegrityCheck_Js", {
    getInstance : function() {
        return new Corrensa_IntegrityCheck_Js();
    },
},{
    registerEventForApiTestButton : function () {
        jQuery(document).on('click','#btnApiTest', function () {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });

            var actionParams = {
                "type": "POST",
                "url": 'index.php',
                "dataType": "html",
                "data": {
                    'module': 'Corrensa',
                    'view': 'APITest'
                }
            };

            var callBackFunction = function(data) {

                app.showScrollBar(jQuery('#APITest'), {
                    'height': '250px'
                });
            };

            AppConnector.request(actionParams).then(
                function(data) {
                    if(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        app.showModalWindow(data, function(data){
                            if(typeof callBackFunction == 'function'){
                                callBackFunction(data);
                            }
                        }, {'width':'400px'});
                    }
                },
                function(error,err){

                }
            );
        });
    },

    registerEventForCompareConfigButton: function() {
        jQuery(document).on('click','#btnCompareConfig', function () {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });

            var actionParams = {
                "type": "POST",
                "url": 'index.php',
                "dataType": "html",
                "data": {
                    'module': 'Corrensa',
                    'view': 'CompareConfig'
                }
            };
            var callBackFunction = function(data) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                app.showScrollBar(jQuery('#CompareConfig'), {
                    'height': '450px'
                });
            };
            AppConnector.request(actionParams).then(
                function(data) {
                    if(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        app.showModalWindow(data, function(data){
                            if(typeof callBackFunction == 'function'){
                                callBackFunction(data);
                            }
                        }, {'width':'800px'});
                    }
                },
                function(error,err){

                }
            );
        });
    },

    registerEvents : function () {
        this.registerEventForApiTestButton();
        this.registerEventForCompareConfigButton();
    }
});